/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.service.AlphaSender;

public class AlphaSenderCreator
extends Creator<AlphaSender> {
    private final String pathServiceSid;
    private final String alphaSender;

    public AlphaSenderCreator(String pathServiceSid, String alphaSender) {
        this.pathServiceSid = pathServiceSid;
        this.alphaSender = alphaSender;
    }

    @Override
    public AlphaSender create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), "/v1/Services/" + this.pathServiceSid + "/AlphaSenders");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AlphaSender creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return AlphaSender.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.alphaSender != null) {
            request.addPostParam("AlphaSender", this.alphaSender);
        }
    }
}

