/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.service.AlphaSenderCreator;
import com.twilio.rest.messaging.v1.service.AlphaSenderDeleter;
import com.twilio.rest.messaging.v1.service.AlphaSenderFetcher;
import com.twilio.rest.messaging.v1.service.AlphaSenderReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AlphaSender
extends Resource {
    private static final long serialVersionUID = 153057609894951L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String alphaSender;
    private final List<String> capabilities;
    private final URI url;

    public static AlphaSenderCreator creator(String pathServiceSid, String alphaSender) {
        return new AlphaSenderCreator(pathServiceSid, alphaSender);
    }

    public static AlphaSenderReader reader(String pathServiceSid) {
        return new AlphaSenderReader(pathServiceSid);
    }

    public static AlphaSenderFetcher fetcher(String pathServiceSid, String pathSid) {
        return new AlphaSenderFetcher(pathServiceSid, pathSid);
    }

    public static AlphaSenderDeleter deleter(String pathServiceSid, String pathSid) {
        return new AlphaSenderDeleter(pathServiceSid, pathSid);
    }

    public static AlphaSender fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (AlphaSender)objectMapper.readValue(json, AlphaSender.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static AlphaSender fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (AlphaSender)objectMapper.readValue(json, AlphaSender.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private AlphaSender(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="alpha_sender") String alphaSender, @JsonProperty(value="capabilities") List<String> capabilities, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.alphaSender = alphaSender;
        this.capabilities = capabilities;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getAlphaSender() {
        return this.alphaSender;
    }

    public final List<String> getCapabilities() {
        return this.capabilities;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlphaSender other = (AlphaSender)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.alphaSender, other.alphaSender) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.alphaSender, this.capabilities, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("alphaSender", (Object)this.alphaSender).add("capabilities", this.capabilities).add("url", (Object)this.url).toString();
    }
}

