/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.insights.v1.call.CallSummaryFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CallSummary
extends Resource {
    private static final long serialVersionUID = 48207038577913L;
    private final String accountSid;
    private final String callSid;
    private final CallType callType;
    private final CallState callState;
    private final ProcessingState processingState;
    private final DateTime startTime;
    private final DateTime endTime;
    private final Integer duration;
    private final Integer connectDuration;
    private final Map<String, Object> from;
    private final Map<String, Object> to;
    private final Map<String, Object> carrierEdge;
    private final Map<String, Object> clientEdge;
    private final Map<String, Object> sdkEdge;
    private final Map<String, Object> sipEdge;
    private final List<String> tags;
    private final URI url;
    private final Map<String, Object> attributes;
    private final Map<String, Object> properties;

    public static CallSummaryFetcher fetcher(String pathCallSid) {
        return new CallSummaryFetcher(pathCallSid);
    }

    public static CallSummary fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (CallSummary)objectMapper.readValue(json, CallSummary.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static CallSummary fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (CallSummary)objectMapper.readValue(json, CallSummary.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private CallSummary(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="call_type") CallType callType, @JsonProperty(value="call_state") CallState callState, @JsonProperty(value="processing_state") ProcessingState processingState, @JsonProperty(value="start_time") String startTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="duration") Integer duration, @JsonProperty(value="connect_duration") Integer connectDuration, @JsonProperty(value="from") Map<String, Object> from, @JsonProperty(value="to") Map<String, Object> to, @JsonProperty(value="carrier_edge") Map<String, Object> carrierEdge, @JsonProperty(value="client_edge") Map<String, Object> clientEdge, @JsonProperty(value="sdk_edge") Map<String, Object> sdkEdge, @JsonProperty(value="sip_edge") Map<String, Object> sipEdge, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="url") URI url, @JsonProperty(value="attributes") Map<String, Object> attributes, @JsonProperty(value="properties") Map<String, Object> properties) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.callType = callType;
        this.callState = callState;
        this.processingState = processingState;
        this.startTime = DateConverter.iso8601DateTimeFromString(startTime);
        this.endTime = DateConverter.iso8601DateTimeFromString(endTime);
        this.duration = duration;
        this.connectDuration = connectDuration;
        this.from = from;
        this.to = to;
        this.carrierEdge = carrierEdge;
        this.clientEdge = clientEdge;
        this.sdkEdge = sdkEdge;
        this.sipEdge = sipEdge;
        this.tags = tags;
        this.url = url;
        this.attributes = attributes;
        this.properties = properties;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final CallType getCallType() {
        return this.callType;
    }

    public final CallState getCallState() {
        return this.callState;
    }

    public final ProcessingState getProcessingState() {
        return this.processingState;
    }

    public final DateTime getStartTime() {
        return this.startTime;
    }

    public final DateTime getEndTime() {
        return this.endTime;
    }

    public final Integer getDuration() {
        return this.duration;
    }

    public final Integer getConnectDuration() {
        return this.connectDuration;
    }

    public final Map<String, Object> getFrom() {
        return this.from;
    }

    public final Map<String, Object> getTo() {
        return this.to;
    }

    public final Map<String, Object> getCarrierEdge() {
        return this.carrierEdge;
    }

    public final Map<String, Object> getClientEdge() {
        return this.clientEdge;
    }

    public final Map<String, Object> getSdkEdge() {
        return this.sdkEdge;
    }

    public final Map<String, Object> getSipEdge() {
        return this.sipEdge;
    }

    public final List<String> getTags() {
        return this.tags;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallSummary other = (CallSummary)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals((Object)this.callType, (Object)other.callType) && Objects.equals((Object)this.callState, (Object)other.callState) && Objects.equals((Object)this.processingState, (Object)other.processingState) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.duration, other.duration) && Objects.equals(this.connectDuration, other.connectDuration) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.carrierEdge, other.carrierEdge) && Objects.equals(this.clientEdge, other.clientEdge) && Objects.equals(this.sdkEdge, other.sdkEdge) && Objects.equals(this.sipEdge, other.sipEdge) && Objects.equals(this.tags, other.tags) && Objects.equals(this.url, other.url) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.properties, other.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.callSid, this.callType, this.callState, this.processingState, this.startTime, this.endTime, this.duration, this.connectDuration, this.from, this.to, this.carrierEdge, this.clientEdge, this.sdkEdge, this.sipEdge, this.tags, this.url, this.attributes, this.properties});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("callSid", (Object)this.callSid).add("callType", (Object)this.callType).add("callState", (Object)this.callState).add("processingState", (Object)this.processingState).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("duration", (Object)this.duration).add("connectDuration", (Object)this.connectDuration).add("from", this.from).add("to", this.to).add("carrierEdge", this.carrierEdge).add("clientEdge", this.clientEdge).add("sdkEdge", this.sdkEdge).add("sipEdge", this.sipEdge).add("tags", this.tags).add("url", (Object)this.url).add("attributes", this.attributes).add("properties", this.properties).toString();
    }

    public static enum ProcessingState {
        COMPLETE("complete"),
        PARTIAL("partial");

        private final String value;

        private ProcessingState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ProcessingState forValue(String value) {
            return (ProcessingState)Promoter.enumFromString((String)value, (Enum[])ProcessingState.values());
        }
    }

    public static enum CallState {
        RINGING("ringing"),
        COMPLETED("completed"),
        BUSY("busy"),
        FAIL("fail"),
        NOANSWER("noanswer"),
        CANCELED("canceled"),
        ANSWERED("answered"),
        UNDIALED("undialed");

        private final String value;

        private CallState(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CallState forValue(String value) {
            return (CallState)Promoter.enumFromString((String)value, (Enum[])CallState.values());
        }
    }

    public static enum CallType {
        CARRIER("carrier"),
        SIP("sip"),
        TRUNKING("trunking"),
        CLIENT("client");

        private final String value;

        private CallType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static CallType forValue(String value) {
            return (CallType)Promoter.enumFromString((String)value, (Enum[])CallType.values());
        }
    }
}

