/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.flexapi.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.flexapi.v1.WebChannelCreator;
import com.twilio.rest.flexapi.v1.WebChannelDeleter;
import com.twilio.rest.flexapi.v1.WebChannelFetcher;
import com.twilio.rest.flexapi.v1.WebChannelReader;
import com.twilio.rest.flexapi.v1.WebChannelUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WebChannel
extends Resource {
    private static final long serialVersionUID = 254450779434929L;
    private final String accountSid;
    private final String flexFlowSid;
    private final String sid;
    private final URI url;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;

    public static WebChannelReader reader() {
        return new WebChannelReader();
    }

    public static WebChannelFetcher fetcher(String pathSid) {
        return new WebChannelFetcher(pathSid);
    }

    public static WebChannelCreator creator(String flexFlowSid, String identity, String customerFriendlyName, String chatFriendlyName) {
        return new WebChannelCreator(flexFlowSid, identity, customerFriendlyName, chatFriendlyName);
    }

    public static WebChannelUpdater updater(String pathSid) {
        return new WebChannelUpdater(pathSid);
    }

    public static WebChannelDeleter deleter(String pathSid) {
        return new WebChannelDeleter(pathSid);
    }

    public static WebChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WebChannel)objectMapper.readValue(json, WebChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WebChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WebChannel)objectMapper.readValue(json, WebChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WebChannel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="flex_flow_sid") String flexFlowSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.accountSid = accountSid;
        this.flexFlowSid = flexFlowSid;
        this.sid = sid;
        this.url = url;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFlexFlowSid() {
        return this.flexFlowSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebChannel other = (WebChannel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.flexFlowSid, other.flexFlowSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.flexFlowSid, this.sid, this.url, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("flexFlowSid", (Object)this.flexFlowSid).add("sid", (Object)this.sid).add("url", (Object)this.url).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).toString();
    }

    public static enum ChatStatus {
        INACTIVE("inactive");

        private final String value;

        private ChatStatus(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ChatStatus forValue(String value) {
            return (ChatStatus)Promoter.enumFromString((String)value, (Enum[])ChatStatus.values());
        }
    }
}

