/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation.message;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.conversation.message.DeliveryReceipt;

public class DeliveryReceiptFetcher
extends Fetcher<DeliveryReceipt> {
    private final String pathChatServiceSid;
    private final String pathConversationSid;
    private final String pathMessageSid;
    private final String pathSid;

    public DeliveryReceiptFetcher(String pathChatServiceSid, String pathConversationSid, String pathMessageSid, String pathSid) {
        this.pathChatServiceSid = pathChatServiceSid;
        this.pathConversationSid = pathConversationSid;
        this.pathMessageSid = pathMessageSid;
        this.pathSid = pathSid;
    }

    @Override
    public DeliveryReceipt fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), "/v1/Services/" + this.pathChatServiceSid + "/Conversations/" + this.pathConversationSid + "/Messages/" + this.pathMessageSid + "/Receipts/" + this.pathSid + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DeliveryReceipt fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return DeliveryReceipt.fromJson(response.getStream(), client.getObjectMapper());
    }
}

