/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.Binding;
import java.util.List;

public class BindingReader
extends Reader<Binding> {
    private final String pathChatServiceSid;
    private List<Binding.BindingType> bindingType;
    private List<String> identity;

    public BindingReader(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    public BindingReader setBindingType(List<Binding.BindingType> bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    public BindingReader setBindingType(Binding.BindingType bindingType) {
        return this.setBindingType(Promoter.listOfOne(bindingType));
    }

    public BindingReader setIdentity(List<String> identity) {
        this.identity = identity;
        return this;
    }

    public BindingReader setIdentity(String identity) {
        return this.setIdentity(Promoter.listOfOne(identity));
    }

    @Override
    public ResourceSet<Binding> read(TwilioRestClient client) {
        return new ResourceSet<Binding>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Binding> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.CONVERSATIONS.toString(), "/v1/Services/" + this.pathChatServiceSid + "/Bindings");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Binding> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Binding> nextPage(Page<Binding> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Binding> previousPage(Page<Binding> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.CONVERSATIONS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Binding> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Binding read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("bindings", response.getContent(), Binding.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.bindingType != null) {
            for (Binding.BindingType bindingType : this.bindingType) {
                request.addQueryParam("BindingType", bindingType.toString());
            }
        }
        if (this.identity != null) {
            for (String string : this.identity) {
                request.addQueryParam("Identity", string);
            }
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

