/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.configuration;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.configuration.Webhook;
import java.util.List;

public class WebhookUpdater
extends Updater<Webhook> {
    private String method;
    private List<String> filters;
    private String preWebhookUrl;
    private String postWebhookUrl;
    private Webhook.Target target;

    public WebhookUpdater setMethod(String method) {
        this.method = method;
        return this;
    }

    public WebhookUpdater setFilters(List<String> filters) {
        this.filters = filters;
        return this;
    }

    public WebhookUpdater setFilters(String filters) {
        return this.setFilters(Promoter.listOfOne(filters));
    }

    public WebhookUpdater setPreWebhookUrl(String preWebhookUrl) {
        this.preWebhookUrl = preWebhookUrl;
        return this;
    }

    public WebhookUpdater setPostWebhookUrl(String postWebhookUrl) {
        this.postWebhookUrl = postWebhookUrl;
        return this;
    }

    public WebhookUpdater setTarget(Webhook.Target target) {
        this.target = target;
        return this;
    }

    @Override
    public Webhook update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Configuration/Webhooks");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.method != null) {
            request.addPostParam("Method", this.method);
        }
        if (this.filters != null) {
            for (String prop : this.filters) {
                request.addPostParam("Filters", prop);
            }
        }
        if (this.preWebhookUrl != null) {
            request.addPostParam("PreWebhookUrl", this.preWebhookUrl);
        }
        if (this.postWebhookUrl != null) {
            request.addPostParam("PostWebhookUrl", this.postWebhookUrl);
        }
        if (this.target != null) {
            request.addPostParam("Target", this.target.toString());
        }
    }
}

