/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.RestoreAssistantUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RestoreAssistant
extends Resource {
    private static final long serialVersionUID = 267361082192414L;
    private final String accountSid;
    private final String sid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String uniqueName;
    private final String friendlyName;
    private final Boolean needsModelBuild;
    private final String latestModelBuildSid;
    private final Boolean logQueries;
    private final String developmentStage;
    private final URI callbackUrl;
    private final String callbackEvents;

    public static RestoreAssistantUpdater updater(String assistant) {
        return new RestoreAssistantUpdater(assistant);
    }

    public static RestoreAssistant fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (RestoreAssistant)objectMapper.readValue(json, RestoreAssistant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static RestoreAssistant fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (RestoreAssistant)objectMapper.readValue(json, RestoreAssistant.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private RestoreAssistant(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="needs_model_build") Boolean needsModelBuild, @JsonProperty(value="latest_model_build_sid") String latestModelBuildSid, @JsonProperty(value="log_queries") Boolean logQueries, @JsonProperty(value="development_stage") String developmentStage, @JsonProperty(value="callback_url") URI callbackUrl, @JsonProperty(value="callback_events") String callbackEvents) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.uniqueName = uniqueName;
        this.friendlyName = friendlyName;
        this.needsModelBuild = needsModelBuild;
        this.latestModelBuildSid = latestModelBuildSid;
        this.logQueries = logQueries;
        this.developmentStage = developmentStage;
        this.callbackUrl = callbackUrl;
        this.callbackEvents = callbackEvents;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Boolean getNeedsModelBuild() {
        return this.needsModelBuild;
    }

    public final String getLatestModelBuildSid() {
        return this.latestModelBuildSid;
    }

    public final Boolean getLogQueries() {
        return this.logQueries;
    }

    public final String getDevelopmentStage() {
        return this.developmentStage;
    }

    public final URI getCallbackUrl() {
        return this.callbackUrl;
    }

    public final String getCallbackEvents() {
        return this.callbackEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreAssistant other = (RestoreAssistant)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.needsModelBuild, other.needsModelBuild) && Objects.equals(this.latestModelBuildSid, other.latestModelBuildSid) && Objects.equals(this.logQueries, other.logQueries) && Objects.equals(this.developmentStage, other.developmentStage) && Objects.equals(this.callbackUrl, other.callbackUrl) && Objects.equals(this.callbackEvents, other.callbackEvents);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.dateCreated, this.dateUpdated, this.uniqueName, this.friendlyName, this.needsModelBuild, this.latestModelBuildSid, this.logQueries, this.developmentStage, this.callbackUrl, this.callbackEvents);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("sid", (Object)this.sid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("uniqueName", (Object)this.uniqueName).add("friendlyName", (Object)this.friendlyName).add("needsModelBuild", (Object)this.needsModelBuild).add("latestModelBuildSid", (Object)this.latestModelBuildSid).add("logQueries", (Object)this.logQueries).add("developmentStage", (Object)this.developmentStage).add("callbackUrl", (Object)this.callbackUrl).add("callbackEvents", (Object)this.callbackEvents).toString();
    }
}

