/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.Recording;
import java.net.URI;
import java.util.List;

public class RecordingCreator
extends Creator<Recording> {
    private String pathAccountSid;
    private final String pathCallSid;
    private List<String> recordingStatusCallbackEvent;
    private URI recordingStatusCallback;
    private HttpMethod recordingStatusCallbackMethod;
    private String trim;
    private String recordingChannels;

    public RecordingCreator(String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    public RecordingCreator(String pathAccountSid, String pathCallSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
    }

    public RecordingCreator setRecordingStatusCallbackEvent(List<String> recordingStatusCallbackEvent) {
        this.recordingStatusCallbackEvent = recordingStatusCallbackEvent;
        return this;
    }

    public RecordingCreator setRecordingStatusCallbackEvent(String recordingStatusCallbackEvent) {
        return this.setRecordingStatusCallbackEvent(Promoter.listOfOne(recordingStatusCallbackEvent));
    }

    public RecordingCreator setRecordingStatusCallback(URI recordingStatusCallback) {
        this.recordingStatusCallback = recordingStatusCallback;
        return this;
    }

    public RecordingCreator setRecordingStatusCallback(String recordingStatusCallback) {
        return this.setRecordingStatusCallback(Promoter.uriFromString(recordingStatusCallback));
    }

    public RecordingCreator setRecordingStatusCallbackMethod(HttpMethod recordingStatusCallbackMethod) {
        this.recordingStatusCallbackMethod = recordingStatusCallbackMethod;
        return this;
    }

    public RecordingCreator setTrim(String trim) {
        this.trim = trim;
        return this;
    }

    public RecordingCreator setRecordingChannels(String recordingChannels) {
        this.recordingChannels = recordingChannels;
        return this;
    }

    @Override
    public Recording create(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Calls/" + this.pathCallSid + "/Recordings.json");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Recording creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Recording.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.recordingStatusCallbackEvent != null) {
            for (String prop : this.recordingStatusCallbackEvent) {
                request.addPostParam("RecordingStatusCallbackEvent", prop);
            }
        }
        if (this.recordingStatusCallback != null) {
            request.addPostParam("RecordingStatusCallback", this.recordingStatusCallback.toString());
        }
        if (this.recordingStatusCallbackMethod != null) {
            request.addPostParam("RecordingStatusCallbackMethod", this.recordingStatusCallbackMethod.toString());
        }
        if (this.trim != null) {
            request.addPostParam("Trim", this.trim);
        }
        if (this.recordingChannels != null) {
            request.addPostParam("RecordingChannels", this.recordingChannels);
        }
    }
}

