/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.ValidationRequestCreator;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ValidationRequest
extends Resource {
    private static final long serialVersionUID = 163352133331334L;
    private final String accountSid;
    private final String callSid;
    private final String friendlyName;
    private final PhoneNumber phoneNumber;
    private final String validationCode;

    public static ValidationRequestCreator creator(String pathAccountSid, PhoneNumber phoneNumber) {
        return new ValidationRequestCreator(pathAccountSid, phoneNumber);
    }

    public static ValidationRequestCreator creator(PhoneNumber phoneNumber) {
        return new ValidationRequestCreator(phoneNumber);
    }

    public static ValidationRequest fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ValidationRequest)objectMapper.readValue(json, ValidationRequest.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ValidationRequest fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ValidationRequest)objectMapper.readValue(json, ValidationRequest.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ValidationRequest(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="call_sid") String callSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="phone_number") PhoneNumber phoneNumber, @JsonProperty(value="validation_code") String validationCode) {
        this.accountSid = accountSid;
        this.callSid = callSid;
        this.friendlyName = friendlyName;
        this.phoneNumber = phoneNumber;
        this.validationCode = validationCode;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getCallSid() {
        return this.callSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final PhoneNumber getPhoneNumber() {
        return this.phoneNumber;
    }

    public final String getValidationCode() {
        return this.validationCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationRequest other = (ValidationRequest)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.callSid, other.callSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.validationCode, other.validationCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.callSid, this.friendlyName, this.phoneNumber, this.validationCode);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("callSid", (Object)this.callSid).add("friendlyName", (Object)this.friendlyName).add("phoneNumber", (Object)this.phoneNumber).add("validationCode", (Object)this.validationCode).toString();
    }
}

