/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.AccountCreator;
import com.twilio.rest.api.v2010.AccountFetcher;
import com.twilio.rest.api.v2010.AccountReader;
import com.twilio.rest.api.v2010.AccountUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Account
extends Resource {
    private static final long serialVersionUID = 82837000699633L;
    private final String authToken;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final String ownerAccountSid;
    private final String sid;
    private final Status status;
    private final Map<String, String> subresourceUris;
    private final Type type;
    private final String uri;

    public static AccountCreator creator() {
        return new AccountCreator();
    }

    public static AccountFetcher fetcher(String pathSid) {
        return new AccountFetcher(pathSid);
    }

    public static AccountFetcher fetcher() {
        return new AccountFetcher();
    }

    public static AccountReader reader() {
        return new AccountReader();
    }

    public static AccountUpdater updater(String pathSid) {
        return new AccountUpdater(pathSid);
    }

    public static AccountUpdater updater() {
        return new AccountUpdater();
    }

    public static Account fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Account)objectMapper.readValue(json, Account.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Account fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Account)objectMapper.readValue(json, Account.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Account(@JsonProperty(value="auth_token") String authToken, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="owner_account_sid") String ownerAccountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="type") Type type, @JsonProperty(value="uri") String uri) {
        this.authToken = authToken;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.ownerAccountSid = ownerAccountSid;
        this.sid = sid;
        this.status = status;
        this.subresourceUris = subresourceUris;
        this.type = type;
        this.uri = uri;
    }

    public final String getAuthToken() {
        return this.authToken;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getOwnerAccountSid() {
        return this.ownerAccountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final Type getType() {
        return this.type;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Account other = (Account)o;
        return Objects.equals(this.authToken, other.authToken) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.ownerAccountSid, other.ownerAccountSid) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authToken, this.dateCreated, this.dateUpdated, this.friendlyName, this.ownerAccountSid, this.sid, this.status, this.subresourceUris, this.type, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authToken", (Object)this.authToken).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("ownerAccountSid", (Object)this.ownerAccountSid).add("sid", (Object)this.sid).add("status", (Object)this.status).add("subresourceUris", this.subresourceUris).add("type", (Object)this.type).add("uri", (Object)this.uri).toString();
    }

    public static enum Type {
        TRIAL("Trial"),
        FULL("Full");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type forValue(String value) {
            return (Type)Promoter.enumFromString((String)value, (Enum[])Type.values());
        }
    }

    public static enum Status {
        ACTIVE("active"),
        SUSPENDED("suspended"),
        CLOSED("closed");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

