/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1.credential;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.accounts.v1.credential.Aws;

public class AwsReader
extends Reader<Aws> {
    @Override
    public ResourceSet<Aws> read(TwilioRestClient client) {
        return new ResourceSet<Aws>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Aws> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.ACCOUNTS.toString(), "/v1/Credentials/AWS");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Aws> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Aws> nextPage(Page<Aws> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.ACCOUNTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Aws> previousPage(Page<Aws> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.ACCOUNTS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Aws> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Aws read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("credentials", response.getContent(), Aws.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

