/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1.sim;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.wireless.v1.sim.UsageRecordReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UsageRecord
extends Resource {
    private static final long serialVersionUID = 59802698873070L;
    private final String simSid;
    private final String accountSid;
    private final Map<String, Object> period;
    private final Map<String, Object> commands;
    private final Map<String, Object> data;

    public static UsageRecordReader reader(String pathSimSid) {
        return new UsageRecordReader(pathSimSid);
    }

    public static UsageRecord fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (UsageRecord)objectMapper.readValue(json, UsageRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UsageRecord fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (UsageRecord)objectMapper.readValue(json, UsageRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UsageRecord(@JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="period") Map<String, Object> period, @JsonProperty(value="commands") Map<String, Object> commands, @JsonProperty(value="data") Map<String, Object> data) {
        this.simSid = simSid;
        this.accountSid = accountSid;
        this.period = period;
        this.commands = commands;
        this.data = data;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getPeriod() {
        return this.period;
    }

    public final Map<String, Object> getCommands() {
        return this.commands;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageRecord other = (UsageRecord)o;
        return Objects.equals(this.simSid, other.simSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.period, other.period) && Objects.equals(this.commands, other.commands) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        return Objects.hash(this.simSid, this.accountSid, this.period, this.commands, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("simSid", (Object)this.simSid).add("accountSid", (Object)this.accountSid).add("period", this.period).add("commands", this.commands).add("data", this.data).toString();
    }

    public static enum Granularity {
        HOURLY("hourly"),
        DAILY("daily"),
        ALL("all");

        private final String value;

        private Granularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Granularity forValue(String value) {
            return (Granularity)Promoter.enumFromString((String)value, (Enum[])Granularity.values());
        }
    }
}

