/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.verify.v2.service.RateLimitCreator;
import com.twilio.rest.verify.v2.service.RateLimitDeleter;
import com.twilio.rest.verify.v2.service.RateLimitFetcher;
import com.twilio.rest.verify.v2.service.RateLimitReader;
import com.twilio.rest.verify.v2.service.RateLimitUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class RateLimit
extends Resource {
    private static final long serialVersionUID = 110366061579267L;
    private final String sid;
    private final String serviceSid;
    private final String accountSid;
    private final String uniqueName;
    private final String description;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static RateLimitCreator creator(String pathServiceSid, String uniqueName) {
        return new RateLimitCreator(pathServiceSid, uniqueName);
    }

    public static RateLimitUpdater updater(String pathServiceSid, String pathSid) {
        return new RateLimitUpdater(pathServiceSid, pathSid);
    }

    public static RateLimitFetcher fetcher(String pathServiceSid, String pathSid) {
        return new RateLimitFetcher(pathServiceSid, pathSid);
    }

    public static RateLimitReader reader(String pathServiceSid) {
        return new RateLimitReader(pathServiceSid);
    }

    public static RateLimitDeleter deleter(String pathServiceSid, String pathSid) {
        return new RateLimitDeleter(pathServiceSid, pathSid);
    }

    public static RateLimit fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (RateLimit)objectMapper.readValue(json, RateLimit.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static RateLimit fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (RateLimit)objectMapper.readValue(json, RateLimit.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private RateLimit(@JsonProperty(value="sid") String sid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="description") String description, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.serviceSid = serviceSid;
        this.accountSid = accountSid;
        this.uniqueName = uniqueName;
        this.description = description;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateLimit other = (RateLimit)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.description, other.description) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.serviceSid, this.accountSid, this.uniqueName, this.description, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("serviceSid", (Object)this.serviceSid).add("accountSid", (Object)this.accountSid).add("uniqueName", (Object)this.uniqueName).add("description", (Object)this.description).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

