/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.workflow;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.taskrouter.v1.workspace.workflow.WorkflowStatistics;
import org.joda.time.DateTime;

public class WorkflowStatisticsFetcher
extends Fetcher<WorkflowStatistics> {
    private final String pathWorkspaceSid;
    private final String pathWorkflowSid;
    private Integer minutes;
    private DateTime startDate;
    private DateTime endDate;
    private String taskChannel;
    private String splitByWaitTime;

    public WorkflowStatisticsFetcher(String pathWorkspaceSid, String pathWorkflowSid) {
        this.pathWorkspaceSid = pathWorkspaceSid;
        this.pathWorkflowSid = pathWorkflowSid;
    }

    public WorkflowStatisticsFetcher setMinutes(Integer minutes) {
        this.minutes = minutes;
        return this;
    }

    public WorkflowStatisticsFetcher setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public WorkflowStatisticsFetcher setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public WorkflowStatisticsFetcher setTaskChannel(String taskChannel) {
        this.taskChannel = taskChannel;
        return this;
    }

    public WorkflowStatisticsFetcher setSplitByWaitTime(String splitByWaitTime) {
        this.splitByWaitTime = splitByWaitTime;
        return this;
    }

    @Override
    public WorkflowStatistics fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.TASKROUTER.toString(), "/v1/Workspaces/" + this.pathWorkspaceSid + "/Workflows/" + this.pathWorkflowSid + "/Statistics");
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("WorkflowStatistics fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return WorkflowStatistics.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.minutes != null) {
            request.addQueryParam("Minutes", this.minutes.toString());
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.taskChannel != null) {
            request.addQueryParam("TaskChannel", this.taskChannel);
        }
        if (this.splitByWaitTime != null) {
            request.addQueryParam("SplitByWaitTime", this.splitByWaitTime);
        }
    }
}

