/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Network;

public class NetworkReader
extends Reader<Network> {
    private String isoCountry;
    private String mcc;
    private String mnc;

    public NetworkReader setIsoCountry(String isoCountry) {
        this.isoCountry = isoCountry;
        return this;
    }

    public NetworkReader setMcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    public NetworkReader setMnc(String mnc) {
        this.mnc = mnc;
        return this;
    }

    @Override
    public ResourceSet<Network> read(TwilioRestClient client) {
        return new ResourceSet<Network>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Network> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SUPERSIM.toString(), "/v1/Networks");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Network> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Network> nextPage(Page<Network> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Network> previousPage(Page<Network> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SUPERSIM.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Network> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Network read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("networks", response.getContent(), Network.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.isoCountry != null) {
            request.addQueryParam("IsoCountry", this.isoCountry);
        }
        if (this.mcc != null) {
            request.addQueryParam("Mcc", this.mcc);
        }
        if (this.mnc != null) {
            request.addQueryParam("Mnc", this.mnc);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

