/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v2;

import com.twilio.base.Updater;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v2.FlowValidate;
import java.util.Map;

public class FlowValidateUpdater
extends Updater<FlowValidate> {
    private final String friendlyName;
    private final FlowValidate.Status status;
    private final Map<String, Object> definition;
    private String commitMessage;

    public FlowValidateUpdater(String friendlyName, FlowValidate.Status status, Map<String, Object> definition) {
        this.friendlyName = friendlyName;
        this.status = status;
        this.definition = definition;
    }

    public FlowValidateUpdater setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
        return this;
    }

    @Override
    public FlowValidate update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), "/v2/Flows/Validate");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FlowValidate update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return FlowValidate.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.definition != null) {
            request.addPostParam("Definition", Converter.mapToJson(this.definition));
        }
        if (this.commitMessage != null) {
            request.addPostParam("CommitMessage", this.commitMessage);
        }
    }
}

