/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.engagement.step;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.engagement.step.StepContext;

public class StepContextFetcher
extends Fetcher<StepContext> {
    private final String pathFlowSid;
    private final String pathEngagementSid;
    private final String pathStepSid;

    public StepContextFetcher(String pathFlowSid, String pathEngagementSid, String pathStepSid) {
        this.pathFlowSid = pathFlowSid;
        this.pathEngagementSid = pathEngagementSid;
        this.pathStepSid = pathStepSid;
    }

    @Override
    public StepContext fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.STUDIO.toString(), "/v1/Flows/" + this.pathFlowSid + "/Engagements/" + this.pathEngagementSid + "/Steps/" + this.pathStepSid + "/Context");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("StepContext fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return StepContext.fromJson(response.getStream(), client.getObjectMapper());
    }
}

