/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.studio.v1.flow.Engagement;
import com.twilio.type.PhoneNumber;
import java.util.Map;

public class EngagementCreator
extends Creator<Engagement> {
    private final String pathFlowSid;
    private final PhoneNumber to;
    private final PhoneNumber from;
    private Map<String, Object> parameters;

    public EngagementCreator(String pathFlowSid, PhoneNumber to, PhoneNumber from) {
        this.pathFlowSid = pathFlowSid;
        this.to = to;
        this.from = from;
    }

    public EngagementCreator setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public Engagement create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.STUDIO.toString(), "/v1/Flows/" + this.pathFlowSid + "/Engagements");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Engagement creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Engagement.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to.toString());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from.toString());
        }
        if (this.parameters != null) {
            request.addPostParam("Parameters", Converter.mapToJson(this.parameters));
        }
    }
}

