/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.understand.assistant.task.TaskActionsFetcher;
import com.twilio.rest.preview.understand.assistant.task.TaskActionsUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskActions
extends Resource {
    private static final long serialVersionUID = 212176093735390L;
    private final String accountSid;
    private final String assistantSid;
    private final String taskSid;
    private final URI url;
    private final Map<String, Object> data;

    public static TaskActionsFetcher fetcher(String pathAssistantSid, String pathTaskSid) {
        return new TaskActionsFetcher(pathAssistantSid, pathTaskSid);
    }

    public static TaskActionsUpdater updater(String pathAssistantSid, String pathTaskSid) {
        return new TaskActionsUpdater(pathAssistantSid, pathTaskSid);
    }

    public static TaskActions fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (TaskActions)objectMapper.readValue(json, TaskActions.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static TaskActions fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (TaskActions)objectMapper.readValue(json, TaskActions.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private TaskActions(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="task_sid") String taskSid, @JsonProperty(value="url") URI url, @JsonProperty(value="data") Map<String, Object> data) {
        this.accountSid = accountSid;
        this.assistantSid = assistantSid;
        this.taskSid = taskSid;
        this.url = url;
        this.data = data;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getTaskSid() {
        return this.taskSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskActions other = (TaskActions)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.taskSid, other.taskSid) && Objects.equals(this.url, other.url) && Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assistantSid, this.taskSid, this.url, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("assistantSid", (Object)this.assistantSid).add("taskSid", (Object)this.taskSid).add("url", (Object)this.url).add("data", this.data).toString();
    }
}

