/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms.business.brand;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.business.brand.BrandedChannelFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BrandedChannel
extends Resource {
    private static final long serialVersionUID = 119049791747662L;
    private final String accountSid;
    private final String businessSid;
    private final String brandSid;
    private final String sid;
    private final Map<String, String> links;
    private final URI url;

    public static BrandedChannelFetcher fetcher(String pathBusinessSid, String pathBrandSid, String pathSid) {
        return new BrandedChannelFetcher(pathBusinessSid, pathBrandSid, pathSid);
    }

    public static BrandedChannel fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (BrandedChannel)objectMapper.readValue(json, BrandedChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static BrandedChannel fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (BrandedChannel)objectMapper.readValue(json, BrandedChannel.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private BrandedChannel(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="business_sid") String businessSid, @JsonProperty(value="brand_sid") String brandSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.businessSid = businessSid;
        this.brandSid = brandSid;
        this.sid = sid;
        this.links = links;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBusinessSid() {
        return this.businessSid;
    }

    public final String getBrandSid() {
        return this.brandSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrandedChannel other = (BrandedChannel)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.businessSid, other.businessSid) && Objects.equals(this.brandSid, other.brandSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.links, other.links) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.businessSid, this.brandSid, this.sid, this.links, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("businessSid", (Object)this.businessSid).add("brandSid", (Object)this.brandSid).add("sid", (Object)this.sid).add("links", this.links).add("url", (Object)this.url).toString();
    }
}

