/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.trustedComms.BrandedCall;

public class BrandedCallCreator
extends Creator<BrandedCall> {
    private final String from;
    private final String to;
    private final String reason;
    private String callSid;

    public BrandedCallCreator(String from, String to, String reason) {
        this.from = from;
        this.to = to;
        this.reason = reason;
    }

    public BrandedCallCreator setCallSid(String callSid) {
        this.callSid = callSid;
        return this;
    }

    @Override
    public BrandedCall create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/TrustedComms/Business/BrandedCalls");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("BrandedCall creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return BrandedCall.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.from != null) {
            request.addPostParam("From", this.from);
        }
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.reason != null) {
            request.addPostParam("Reason", this.reason);
        }
        if (this.callSid != null) {
            request.addPostParam("CallSid", this.callSid);
        }
    }
}

