/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.bulkExports.export;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.bulkExports.export.Day;

public class DayReader
extends Reader<Day> {
    private final String pathResourceType;
    private String nextToken;
    private String previousToken;

    public DayReader(String pathResourceType) {
        this.pathResourceType = pathResourceType;
    }

    public DayReader setNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public DayReader setPreviousToken(String previousToken) {
        this.previousToken = previousToken;
        return this;
    }

    @Override
    public ResourceSet<Day> read(TwilioRestClient client) {
        return new ResourceSet<Day>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Day> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/BulkExports/Exports/" + this.pathResourceType + "/Days");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Day> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Day> nextPage(Page<Day> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Day> previousPage(Page<Day> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Day> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Day read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("days", response.getContent(), Day.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.nextToken != null) {
            request.addQueryParam("NextToken", this.nextToken);
        }
        if (this.previousToken != null) {
            request.addQueryParam("PreviousToken", this.previousToken);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

