/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.numbers.v2.regulatorycompliance;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentTypeFetcher;
import com.twilio.rest.numbers.v2.regulatorycompliance.SupportingDocumentTypeReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SupportingDocumentType
extends Resource {
    private static final long serialVersionUID = 122060765056135L;
    private final String sid;
    private final String friendlyName;
    private final String machineName;
    private final List<Map<String, Object>> fields;
    private final URI url;

    public static SupportingDocumentTypeReader reader() {
        return new SupportingDocumentTypeReader();
    }

    public static SupportingDocumentTypeFetcher fetcher(String pathSid) {
        return new SupportingDocumentTypeFetcher(pathSid);
    }

    public static SupportingDocumentType fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (SupportingDocumentType)objectMapper.readValue(json, SupportingDocumentType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SupportingDocumentType fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (SupportingDocumentType)objectMapper.readValue(json, SupportingDocumentType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SupportingDocumentType(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="machine_name") String machineName, @JsonProperty(value="fields") List<Map<String, Object>> fields, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.machineName = machineName;
        this.fields = fields;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getMachineName() {
        return this.machineName;
    }

    public final List<Map<String, Object>> getFields() {
        return this.fields;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupportingDocumentType other = (SupportingDocumentType)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.machineName, other.machineName) && Objects.equals(this.fields, other.fields) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.friendlyName, this.machineName, this.fields, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("friendlyName", (Object)this.friendlyName).add("machineName", (Object)this.machineName).add("fields", this.fields).add("url", (Object)this.url).toString();
    }
}

