/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.messaging.v1.service.ShortCodeCreator;
import com.twilio.rest.messaging.v1.service.ShortCodeDeleter;
import com.twilio.rest.messaging.v1.service.ShortCodeFetcher;
import com.twilio.rest.messaging.v1.service.ShortCodeReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ShortCode
extends Resource {
    private static final long serialVersionUID = 191632597031887L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String shortCode;
    private final String countryCode;
    private final List<String> capabilities;
    private final URI url;

    public static ShortCodeCreator creator(String pathServiceSid, String shortCodeSid) {
        return new ShortCodeCreator(pathServiceSid, shortCodeSid);
    }

    public static ShortCodeDeleter deleter(String pathServiceSid, String pathSid) {
        return new ShortCodeDeleter(pathServiceSid, pathSid);
    }

    public static ShortCodeReader reader(String pathServiceSid) {
        return new ShortCodeReader(pathServiceSid);
    }

    public static ShortCodeFetcher fetcher(String pathServiceSid, String pathSid) {
        return new ShortCodeFetcher(pathServiceSid, pathSid);
    }

    public static ShortCode fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ShortCode)objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ShortCode fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ShortCode)objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ShortCode(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="short_code") String shortCode, @JsonProperty(value="country_code") String countryCode, @JsonProperty(value="capabilities") List<String> capabilities, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.shortCode = shortCode;
        this.countryCode = countryCode;
        this.capabilities = capabilities;
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getShortCode() {
        return this.shortCode;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final List<String> getCapabilities() {
        return this.capabilities;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortCode other = (ShortCode)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.shortCode, other.shortCode) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.shortCode, this.countryCode, this.capabilities, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("shortCode", (Object)this.shortCode).add("countryCode", (Object)this.countryCode).add("capabilities", this.capabilities).add("url", (Object)this.url).toString();
    }
}

