/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.insights.v1.call;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.insights.v1.call.CallSummary;

public class CallSummaryFetcher
extends Fetcher<CallSummary> {
    private final String pathCallSid;
    private CallSummary.ProcessingState processingState;

    public CallSummaryFetcher(String pathCallSid) {
        this.pathCallSid = pathCallSid;
    }

    public CallSummaryFetcher setProcessingState(CallSummary.ProcessingState processingState) {
        this.processingState = processingState;
        return this;
    }

    @Override
    public CallSummary fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.INSIGHTS.toString(), "/v1/Voice/" + this.pathCallSid + "/Summary");
        this.addQueryParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CallSummary fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return CallSummary.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.processingState != null) {
            request.addQueryParam("ProcessingState", this.processingState.toString());
        }
    }
}

