/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service.conversation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.conversations.v1.service.conversation.MessageCreator;
import com.twilio.rest.conversations.v1.service.conversation.MessageDeleter;
import com.twilio.rest.conversations.v1.service.conversation.MessageFetcher;
import com.twilio.rest.conversations.v1.service.conversation.MessageReader;
import com.twilio.rest.conversations.v1.service.conversation.MessageUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends Resource {
    private static final long serialVersionUID = 166901888663263L;
    private final String accountSid;
    private final String chatServiceSid;
    private final String conversationSid;
    private final String sid;
    private final Integer index;
    private final String author;
    private final String body;
    private final List<Map<String, Object>> media;
    private final String attributes;
    private final String participantSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Map<String, Object> delivery;
    private final URI url;
    private final Map<String, String> links;

    public static MessageCreator creator(String pathChatServiceSid, String pathConversationSid) {
        return new MessageCreator(pathChatServiceSid, pathConversationSid);
    }

    public static MessageUpdater updater(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        return new MessageUpdater(pathChatServiceSid, pathConversationSid, pathSid);
    }

    public static MessageDeleter deleter(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        return new MessageDeleter(pathChatServiceSid, pathConversationSid, pathSid);
    }

    public static MessageFetcher fetcher(String pathChatServiceSid, String pathConversationSid, String pathSid) {
        return new MessageFetcher(pathChatServiceSid, pathConversationSid, pathSid);
    }

    public static MessageReader reader(String pathChatServiceSid, String pathConversationSid) {
        return new MessageReader(pathChatServiceSid, pathConversationSid);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Message)objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Message)objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="chat_service_sid") String chatServiceSid, @JsonProperty(value="conversation_sid") String conversationSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="index") Integer index, @JsonProperty(value="author") String author, @JsonProperty(value="body") String body, @JsonProperty(value="media") List<Map<String, Object>> media, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="participant_sid") String participantSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="delivery") Map<String, Object> delivery, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.chatServiceSid = chatServiceSid;
        this.conversationSid = conversationSid;
        this.sid = sid;
        this.index = index;
        this.author = author;
        this.body = body;
        this.media = media;
        this.attributes = attributes;
        this.participantSid = participantSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.delivery = delivery;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getChatServiceSid() {
        return this.chatServiceSid;
    }

    public final String getConversationSid() {
        return this.conversationSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Integer getIndex() {
        return this.index;
    }

    public final String getAuthor() {
        return this.author;
    }

    public final String getBody() {
        return this.body;
    }

    public final List<Map<String, Object>> getMedia() {
        return this.media;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final String getParticipantSid() {
        return this.participantSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Map<String, Object> getDelivery() {
        return this.delivery;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.chatServiceSid, other.chatServiceSid) && Objects.equals(this.conversationSid, other.conversationSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.index, other.index) && Objects.equals(this.author, other.author) && Objects.equals(this.body, other.body) && Objects.equals(this.media, other.media) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.participantSid, other.participantSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.delivery, other.delivery) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.chatServiceSid, this.conversationSid, this.sid, this.index, this.author, this.body, this.media, this.attributes, this.participantSid, this.dateCreated, this.dateUpdated, this.delivery, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("chatServiceSid", (Object)this.chatServiceSid).add("conversationSid", (Object)this.conversationSid).add("sid", (Object)this.sid).add("index", (Object)this.index).add("author", (Object)this.author).add("body", (Object)this.body).add("media", this.media).add("attributes", (Object)this.attributes).add("participantSid", (Object)this.participantSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("delivery", this.delivery).add("url", (Object)this.url).add("links", this.links).toString();
    }

    public static enum WebhookEnabledType {
        TRUE("true"),
        FALSE("false");

        private final String value;

        private WebhookEnabledType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static WebhookEnabledType forValue(String value) {
            return (WebhookEnabledType)Promoter.enumFromString((String)value, (Enum[])WebhookEnabledType.values());
        }
    }
}

