/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.ConnectApp;
import java.net.URI;
import java.util.List;

public class ConnectAppUpdater
extends Updater<ConnectApp> {
    private String pathAccountSid;
    private final String pathSid;
    private URI authorizeRedirectUrl;
    private String companyName;
    private HttpMethod deauthorizeCallbackMethod;
    private URI deauthorizeCallbackUrl;
    private String description;
    private String friendlyName;
    private URI homepageUrl;
    private List<ConnectApp.Permission> permissions;

    public ConnectAppUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ConnectAppUpdater(String pathAccountSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    public ConnectAppUpdater setAuthorizeRedirectUrl(URI authorizeRedirectUrl) {
        this.authorizeRedirectUrl = authorizeRedirectUrl;
        return this;
    }

    public ConnectAppUpdater setAuthorizeRedirectUrl(String authorizeRedirectUrl) {
        return this.setAuthorizeRedirectUrl(Promoter.uriFromString(authorizeRedirectUrl));
    }

    public ConnectAppUpdater setCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    public ConnectAppUpdater setDeauthorizeCallbackMethod(HttpMethod deauthorizeCallbackMethod) {
        this.deauthorizeCallbackMethod = deauthorizeCallbackMethod;
        return this;
    }

    public ConnectAppUpdater setDeauthorizeCallbackUrl(URI deauthorizeCallbackUrl) {
        this.deauthorizeCallbackUrl = deauthorizeCallbackUrl;
        return this;
    }

    public ConnectAppUpdater setDeauthorizeCallbackUrl(String deauthorizeCallbackUrl) {
        return this.setDeauthorizeCallbackUrl(Promoter.uriFromString(deauthorizeCallbackUrl));
    }

    public ConnectAppUpdater setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConnectAppUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConnectAppUpdater setHomepageUrl(URI homepageUrl) {
        this.homepageUrl = homepageUrl;
        return this;
    }

    public ConnectAppUpdater setHomepageUrl(String homepageUrl) {
        return this.setHomepageUrl(Promoter.uriFromString(homepageUrl));
    }

    public ConnectAppUpdater setPermissions(List<ConnectApp.Permission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public ConnectAppUpdater setPermissions(ConnectApp.Permission permissions) {
        return this.setPermissions(Promoter.listOfOne(permissions));
    }

    @Override
    public ConnectApp update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/ConnectApps/" + this.pathSid + ".json");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("ConnectApp update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return ConnectApp.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.authorizeRedirectUrl != null) {
            request.addPostParam("AuthorizeRedirectUrl", this.authorizeRedirectUrl.toString());
        }
        if (this.companyName != null) {
            request.addPostParam("CompanyName", this.companyName);
        }
        if (this.deauthorizeCallbackMethod != null) {
            request.addPostParam("DeauthorizeCallbackMethod", this.deauthorizeCallbackMethod.toString());
        }
        if (this.deauthorizeCallbackUrl != null) {
            request.addPostParam("DeauthorizeCallbackUrl", this.deauthorizeCallbackUrl.toString());
        }
        if (this.description != null) {
            request.addPostParam("Description", this.description);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.homepageUrl != null) {
            request.addPostParam("HomepageUrl", this.homepageUrl.toString());
        }
        if (this.permissions != null) {
            for (ConnectApp.Permission prop : this.permissions) {
                request.addPostParam("Permissions", prop.toString());
            }
        }
    }
}

