/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.Conference;
import java.net.URI;

public class ConferenceUpdater
extends Updater<Conference> {
    private String pathAccountSid;
    private final String pathSid;
    private Conference.UpdateStatus status;
    private URI announceUrl;
    private HttpMethod announceMethod;

    public ConferenceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ConferenceUpdater(String pathAccountSid, String pathSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathSid = pathSid;
    }

    public ConferenceUpdater setStatus(Conference.UpdateStatus status) {
        this.status = status;
        return this;
    }

    public ConferenceUpdater setAnnounceUrl(URI announceUrl) {
        this.announceUrl = announceUrl;
        return this;
    }

    public ConferenceUpdater setAnnounceUrl(String announceUrl) {
        return this.setAnnounceUrl(Promoter.uriFromString(announceUrl));
    }

    public ConferenceUpdater setAnnounceMethod(HttpMethod announceMethod) {
        this.announceMethod = announceMethod;
        return this;
    }

    @Override
    public Conference update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences/" + this.pathSid + ".json");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conference update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Conference.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
        if (this.announceUrl != null) {
            request.addPostParam("AnnounceUrl", this.announceUrl.toString());
        }
        if (this.announceMethod != null) {
            request.addPostParam("AnnounceMethod", this.announceMethod.toString());
        }
    }
}

