/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.accounts.v1.credential;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.accounts.v1.credential.AwsCreator;
import com.twilio.rest.accounts.v1.credential.AwsDeleter;
import com.twilio.rest.accounts.v1.credential.AwsFetcher;
import com.twilio.rest.accounts.v1.credential.AwsReader;
import com.twilio.rest.accounts.v1.credential.AwsUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Aws
extends Resource {
    private static final long serialVersionUID = 108884981918794L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static AwsReader reader() {
        return new AwsReader();
    }

    public static AwsCreator creator(String credentials) {
        return new AwsCreator(credentials);
    }

    public static AwsFetcher fetcher(String pathSid) {
        return new AwsFetcher(pathSid);
    }

    public static AwsUpdater updater(String pathSid) {
        return new AwsUpdater(pathSid);
    }

    public static AwsDeleter deleter(String pathSid) {
        return new AwsDeleter(pathSid);
    }

    public static Aws fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Aws)objectMapper.readValue(json, Aws.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Aws fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Aws)objectMapper.readValue(json, Aws.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Aws(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aws other = (Aws)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

