/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.taskrouter;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.taskrouter.TaskRouterResource;
import java.io.IOException;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowRuleTarget
extends TaskRouterResource {
    @JsonProperty(value="queue")
    private final String queue;
    @JsonProperty(value="expression")
    private final String expression;
    @JsonProperty(value="priority")
    private final Integer priority;
    @JsonProperty(value="timeout")
    private final Integer timeout;
    @JsonProperty(value="order_by")
    private final String orderBy;
    @JsonProperty(value="skip_if")
    private final String skipIf;

    @JsonCreator
    private WorkflowRuleTarget(@JsonProperty(value="queue") String queue, @JsonProperty(value="expression") String expression, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="timeout") Integer timeout, @JsonProperty(value="order_by") String orderBy, @JsonProperty(value="skip_if") String skipIf) {
        this.queue = queue;
        this.expression = expression;
        this.priority = priority;
        this.timeout = timeout;
        this.orderBy = orderBy;
        this.skipIf = skipIf;
    }

    private WorkflowRuleTarget(Builder b) throws IllegalArgumentException {
        this.queue = b.queue;
        this.expression = b.expression;
        this.priority = b.priority;
        this.timeout = b.timeout;
        this.orderBy = b.orderBy;
        this.skipIf = b.skipIf;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getExpression() {
        return this.expression;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public String getSkipIf() {
        return this.skipIf;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queue", (Object)this.queue).add("expression", (Object)this.expression).add("priority", (Object)this.priority).add("timeout", (Object)this.timeout).add("orderBy", (Object)this.orderBy).add("skipIf", (Object)this.skipIf).toString();
    }

    public static WorkflowRuleTarget fromJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (WorkflowRuleTarget)mapper.readValue(json, WorkflowRuleTarget.class);
    }

    public static class Builder {
        private String queue;
        private String expression;
        private Integer priority;
        private Integer timeout;
        private String orderBy;
        private String skipIf;

        public Builder(String queue) {
            this.queue = queue;
        }

        public Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder orderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public Builder skipIf(String skipIf) {
            this.skipIf = skipIf;
            return this;
        }

        public WorkflowRuleTarget build() {
            return new WorkflowRuleTarget(this);
        }
    }
}

