/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.voice.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.voice.v1.SourceIpMappingCreator;
import com.twilio.rest.voice.v1.SourceIpMappingDeleter;
import com.twilio.rest.voice.v1.SourceIpMappingFetcher;
import com.twilio.rest.voice.v1.SourceIpMappingReader;
import com.twilio.rest.voice.v1.SourceIpMappingUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SourceIpMapping
extends Resource {
    private static final long serialVersionUID = 88517684058866L;
    private final String sid;
    private final String ipRecordSid;
    private final String sipDomainSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;

    public static SourceIpMappingCreator creator(String ipRecordSid, String sipDomainSid) {
        return new SourceIpMappingCreator(ipRecordSid, sipDomainSid);
    }

    public static SourceIpMappingFetcher fetcher(String pathSid) {
        return new SourceIpMappingFetcher(pathSid);
    }

    public static SourceIpMappingReader reader() {
        return new SourceIpMappingReader();
    }

    public static SourceIpMappingUpdater updater(String pathSid, String sipDomainSid) {
        return new SourceIpMappingUpdater(pathSid, sipDomainSid);
    }

    public static SourceIpMappingDeleter deleter(String pathSid) {
        return new SourceIpMappingDeleter(pathSid);
    }

    public static SourceIpMapping fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (SourceIpMapping)objectMapper.readValue(json, SourceIpMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SourceIpMapping fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (SourceIpMapping)objectMapper.readValue(json, SourceIpMapping.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SourceIpMapping(@JsonProperty(value="sid") String sid, @JsonProperty(value="ip_record_sid") String ipRecordSid, @JsonProperty(value="sip_domain_sid") String sipDomainSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url) {
        this.sid = sid;
        this.ipRecordSid = ipRecordSid;
        this.sipDomainSid = sipDomainSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getIpRecordSid() {
        return this.ipRecordSid;
    }

    public final String getSipDomainSid() {
        return this.sipDomainSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceIpMapping other = (SourceIpMapping)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.ipRecordSid, other.ipRecordSid) && Objects.equals(this.sipDomainSid, other.sipDomainSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.ipRecordSid, this.sipDomainSid, this.dateCreated, this.dateUpdated, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("ipRecordSid", (Object)this.ipRecordSid).add("sipDomainSid", (Object)this.sipDomainSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).toString();
    }
}

