/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.Webhook;
import java.util.List;

public class WebhookUpdater
extends Updater<Webhook> {
    private final String pathServiceSid;
    private final String pathSid;
    private String friendlyName;
    private List<String> eventTypes;
    private String webhookUrl;
    private Webhook.Status status;

    public WebhookUpdater(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    public WebhookUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public WebhookUpdater setEventTypes(List<String> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public WebhookUpdater setEventTypes(String eventTypes) {
        return this.setEventTypes(Promoter.listOfOne(eventTypes));
    }

    public WebhookUpdater setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
        return this;
    }

    public WebhookUpdater setStatus(Webhook.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public Webhook update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/Webhooks/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Webhook update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Webhook.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.eventTypes != null) {
            for (String prop : this.eventTypes) {
                request.addPostParam("EventTypes", prop);
            }
        }
        if (this.webhookUrl != null) {
            request.addPostParam("WebhookUrl", this.webhookUrl);
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

