/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v2.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v2.service.VerificationCheck;

public class VerificationCheckCreator
extends Creator<VerificationCheck> {
    private final String pathServiceSid;
    private final String code;
    private String to;
    private String verificationSid;
    private String amount;
    private String payee;

    public VerificationCheckCreator(String pathServiceSid, String code) {
        this.pathServiceSid = pathServiceSid;
        this.code = code;
    }

    public VerificationCheckCreator setTo(String to) {
        this.to = to;
        return this;
    }

    public VerificationCheckCreator setVerificationSid(String verificationSid) {
        this.verificationSid = verificationSid;
        return this;
    }

    public VerificationCheckCreator setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public VerificationCheckCreator setPayee(String payee) {
        this.payee = payee;
        return this;
    }

    @Override
    public VerificationCheck create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v2/Services/" + this.pathServiceSid + "/VerificationCheck");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("VerificationCheck creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return VerificationCheck.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.code != null) {
            request.addPostParam("Code", this.code);
        }
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.verificationSid != null) {
            request.addPostParam("VerificationSid", this.verificationSid);
        }
        if (this.amount != null) {
            request.addPostParam("Amount", this.amount);
        }
        if (this.payee != null) {
            request.addPostParam("Payee", this.payee);
        }
    }
}

