/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.worker.WorkersRealTimeStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkersRealTimeStatistics
extends Resource {
    private static final long serialVersionUID = 59891376471139L;
    private final String accountSid;
    private final List<Map<String, Object>> activityStatistics;
    private final Integer totalWorkers;
    private final String workspaceSid;
    private final URI url;

    public static WorkersRealTimeStatisticsFetcher fetcher(String pathWorkspaceSid) {
        return new WorkersRealTimeStatisticsFetcher(pathWorkspaceSid);
    }

    public static WorkersRealTimeStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (WorkersRealTimeStatistics)objectMapper.readValue(json, WorkersRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkersRealTimeStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (WorkersRealTimeStatistics)objectMapper.readValue(json, WorkersRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkersRealTimeStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="activity_statistics") List<Map<String, Object>> activityStatistics, @JsonProperty(value="total_workers") Integer totalWorkers, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.activityStatistics = activityStatistics;
        this.totalWorkers = totalWorkers;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final List<Map<String, Object>> getActivityStatistics() {
        return this.activityStatistics;
    }

    public final Integer getTotalWorkers() {
        return this.totalWorkers;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkersRealTimeStatistics other = (WorkersRealTimeStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.activityStatistics, other.activityStatistics) && Objects.equals(this.totalWorkers, other.totalWorkers) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.activityStatistics, this.totalWorkers, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("activityStatistics", this.activityStatistics).add("totalWorkers", (Object)this.totalWorkers).add("workspaceSid", (Object)this.workspaceSid).add("url", (Object)this.url).toString();
    }
}

