/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service.synclist;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.synclist.SyncListItem;

public class SyncListItemReader
extends Reader<SyncListItem> {
    private final String pathServiceSid;
    private final String pathListSid;
    private SyncListItem.QueryResultOrder order;
    private String from;
    private SyncListItem.QueryFromBoundType bounds;

    public SyncListItemReader(String pathServiceSid, String pathListSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathListSid = pathListSid;
    }

    public SyncListItemReader setOrder(SyncListItem.QueryResultOrder order) {
        this.order = order;
        return this;
    }

    public SyncListItemReader setFrom(String from) {
        this.from = from;
        return this;
    }

    public SyncListItemReader setBounds(SyncListItem.QueryFromBoundType bounds) {
        this.bounds = bounds;
        return this;
    }

    @Override
    public ResourceSet<SyncListItem> read(TwilioRestClient client) {
        return new ResourceSet<SyncListItem>(this, client, this.firstPage(client));
    }

    @Override
    public Page<SyncListItem> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SYNC.toString(), "/v1/Services/" + this.pathServiceSid + "/Lists/" + this.pathListSid + "/Items");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncListItem> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncListItem> nextPage(Page<SyncListItem> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<SyncListItem> previousPage(Page<SyncListItem> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SYNC.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<SyncListItem> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncListItem read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("items", response.getContent(), SyncListItem.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.order != null) {
            request.addQueryParam("Order", this.order.toString());
        }
        if (this.from != null) {
            request.addQueryParam("From", this.from);
        }
        if (this.bounds != null) {
            request.addQueryParam("Bounds", this.bounds.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

