/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.serverless.v1.service.environment;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.serverless.v1.service.environment.Log;
import org.joda.time.DateTime;

public class LogReader
extends Reader<Log> {
    private final String pathServiceSid;
    private final String pathEnvironmentSid;
    private String functionSid;
    private DateTime startDate;
    private DateTime endDate;

    public LogReader(String pathServiceSid, String pathEnvironmentSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathEnvironmentSid = pathEnvironmentSid;
    }

    public LogReader setFunctionSid(String functionSid) {
        this.functionSid = functionSid;
        return this;
    }

    public LogReader setStartDate(DateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public LogReader setEndDate(DateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public ResourceSet<Log> read(TwilioRestClient client) {
        return new ResourceSet<Log>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Log> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.SERVERLESS.toString(), "/v1/Services/" + this.pathServiceSid + "/Environments/" + this.pathEnvironmentSid + "/Logs");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Log> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Log> nextPage(Page<Log> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.SERVERLESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Log> previousPage(Page<Log> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.SERVERLESS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Log> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Log read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("logs", response.getContent(), Log.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.functionSid != null) {
            request.addQueryParam("FunctionSid", this.functionSid);
        }
        if (this.startDate != null) {
            request.addQueryParam("StartDate", this.startDate.toString());
        }
        if (this.endDate != null) {
            request.addQueryParam("EndDate", this.endDate.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

