/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service.session.participant;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.proxy.v1.service.session.participant.MessageInteraction;

public class MessageInteractionReader
extends Reader<MessageInteraction> {
    private final String pathServiceSid;
    private final String pathSessionSid;
    private final String pathParticipantSid;

    public MessageInteractionReader(String pathServiceSid, String pathSessionSid, String pathParticipantSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSessionSid = pathSessionSid;
        this.pathParticipantSid = pathParticipantSid;
    }

    @Override
    public ResourceSet<MessageInteraction> read(TwilioRestClient client) {
        return new ResourceSet<MessageInteraction>(this, client, this.firstPage(client));
    }

    @Override
    public Page<MessageInteraction> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PROXY.toString(), "/v1/Services/" + this.pathServiceSid + "/Sessions/" + this.pathSessionSid + "/Participants/" + this.pathParticipantSid + "/MessageInteractions");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<MessageInteraction> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<MessageInteraction> nextPage(Page<MessageInteraction> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PROXY.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<MessageInteraction> previousPage(Page<MessageInteraction> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PROXY.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<MessageInteraction> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("MessageInteraction read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("interactions", response.getContent(), MessageInteraction.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

