/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.proxy.v1.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.proxy.v1.service.ShortCodeCreator;
import com.twilio.rest.proxy.v1.service.ShortCodeDeleter;
import com.twilio.rest.proxy.v1.service.ShortCodeFetcher;
import com.twilio.rest.proxy.v1.service.ShortCodeReader;
import com.twilio.rest.proxy.v1.service.ShortCodeUpdater;
import com.twilio.type.PhoneNumberCapabilities;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ShortCode
extends Resource {
    private static final long serialVersionUID = 62346607367423L;
    private final String sid;
    private final String accountSid;
    private final String serviceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String shortCode;
    private final String isoCountry;
    private final PhoneNumberCapabilities capabilities;
    private final URI url;
    private final Boolean isReserved;

    public static ShortCodeCreator creator(String pathServiceSid, String sid) {
        return new ShortCodeCreator(pathServiceSid, sid);
    }

    public static ShortCodeDeleter deleter(String pathServiceSid, String pathSid) {
        return new ShortCodeDeleter(pathServiceSid, pathSid);
    }

    public static ShortCodeReader reader(String pathServiceSid) {
        return new ShortCodeReader(pathServiceSid);
    }

    public static ShortCodeFetcher fetcher(String pathServiceSid, String pathSid) {
        return new ShortCodeFetcher(pathServiceSid, pathSid);
    }

    public static ShortCodeUpdater updater(String pathServiceSid, String pathSid) {
        return new ShortCodeUpdater(pathServiceSid, pathSid);
    }

    public static ShortCode fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (ShortCode)objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static ShortCode fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (ShortCode)objectMapper.readValue(json, ShortCode.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private ShortCode(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="service_sid") String serviceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="short_code") String shortCode, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="capabilities") PhoneNumberCapabilities capabilities, @JsonProperty(value="url") URI url, @JsonProperty(value="is_reserved") Boolean isReserved) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.serviceSid = serviceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.shortCode = shortCode;
        this.isoCountry = isoCountry;
        this.capabilities = capabilities;
        this.url = url;
        this.isReserved = isReserved;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getServiceSid() {
        return this.serviceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getShortCode() {
        return this.shortCode;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final PhoneNumberCapabilities getCapabilities() {
        return this.capabilities;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Boolean getIsReserved() {
        return this.isReserved;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortCode other = (ShortCode)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.serviceSid, other.serviceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.shortCode, other.shortCode) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.capabilities, other.capabilities) && Objects.equals(this.url, other.url) && Objects.equals(this.isReserved, other.isReserved);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.serviceSid, this.dateCreated, this.dateUpdated, this.shortCode, this.isoCountry, this.capabilities, this.url, this.isReserved);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("serviceSid", (Object)this.serviceSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("shortCode", (Object)this.shortCode).add("isoCountry", (Object)this.isoCountry).add("capabilities", (Object)this.capabilities).add("url", (Object)this.url).add("isReserved", (Object)this.isReserved).toString();
    }
}

