/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.understand.assistant.TaskCreator;
import com.twilio.rest.preview.understand.assistant.TaskDeleter;
import com.twilio.rest.preview.understand.assistant.TaskFetcher;
import com.twilio.rest.preview.understand.assistant.TaskReader;
import com.twilio.rest.preview.understand.assistant.TaskUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
extends Resource {
    private static final long serialVersionUID = 120802226226536L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Map<String, String> links;
    private final String assistantSid;
    private final String sid;
    private final String uniqueName;
    private final URI actionsUrl;
    private final URI url;

    public static TaskFetcher fetcher(String pathAssistantSid, String pathSid) {
        return new TaskFetcher(pathAssistantSid, pathSid);
    }

    public static TaskReader reader(String pathAssistantSid) {
        return new TaskReader(pathAssistantSid);
    }

    public static TaskCreator creator(String pathAssistantSid, String uniqueName) {
        return new TaskCreator(pathAssistantSid, uniqueName);
    }

    public static TaskUpdater updater(String pathAssistantSid, String pathSid) {
        return new TaskUpdater(pathAssistantSid, pathSid);
    }

    public static TaskDeleter deleter(String pathAssistantSid, String pathSid) {
        return new TaskDeleter(pathAssistantSid, pathSid);
    }

    public static Task fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Task)objectMapper.readValue(json, Task.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Task fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Task)objectMapper.readValue(json, Task.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Task(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="actions_url") URI actionsUrl, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.links = links;
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.actionsUrl = actionsUrl;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getActionsUrl() {
        return this.actionsUrl;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task other = (Task)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.links, other.links) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.actionsUrl, other.actionsUrl) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.links, this.assistantSid, this.sid, this.uniqueName, this.actionsUrl, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("links", this.links).add("assistantSid", (Object)this.assistantSid).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("actionsUrl", (Object)this.actionsUrl).add("url", (Object)this.url).toString();
    }
}

