/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.understand.assistant.FieldTypeCreator;
import com.twilio.rest.preview.understand.assistant.FieldTypeDeleter;
import com.twilio.rest.preview.understand.assistant.FieldTypeFetcher;
import com.twilio.rest.preview.understand.assistant.FieldTypeReader;
import com.twilio.rest.preview.understand.assistant.FieldTypeUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FieldType
extends Resource {
    private static final long serialVersionUID = 595362134429L;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final String friendlyName;
    private final Map<String, String> links;
    private final String assistantSid;
    private final String sid;
    private final String uniqueName;
    private final URI url;

    public static FieldTypeFetcher fetcher(String pathAssistantSid, String pathSid) {
        return new FieldTypeFetcher(pathAssistantSid, pathSid);
    }

    public static FieldTypeReader reader(String pathAssistantSid) {
        return new FieldTypeReader(pathAssistantSid);
    }

    public static FieldTypeCreator creator(String pathAssistantSid, String uniqueName) {
        return new FieldTypeCreator(pathAssistantSid, uniqueName);
    }

    public static FieldTypeUpdater updater(String pathAssistantSid, String pathSid) {
        return new FieldTypeUpdater(pathAssistantSid, pathSid);
    }

    public static FieldTypeDeleter deleter(String pathAssistantSid, String pathSid) {
        return new FieldTypeDeleter(pathAssistantSid, pathSid);
    }

    public static FieldType fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (FieldType)objectMapper.readValue(json, FieldType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static FieldType fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (FieldType)objectMapper.readValue(json, FieldType.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private FieldType(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.friendlyName = friendlyName;
        this.links = links;
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldType other = (FieldType)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.links, other.links) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.dateCreated, this.dateUpdated, this.friendlyName, this.links, this.assistantSid, this.sid, this.uniqueName, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("friendlyName", (Object)this.friendlyName).add("links", this.links).add("assistantSid", (Object)this.assistantSid).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("url", (Object)this.url).toString();
    }
}

