/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.BusinessFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Business
extends Resource {
    private static final long serialVersionUID = 166326640131270L;
    private final String accountSid;
    private final String sid;
    private final URI url;
    private final Map<String, String> links;

    public static BusinessFetcher fetcher(String pathSid) {
        return new BusinessFetcher(pathSid);
    }

    public static Business fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Business)objectMapper.readValue(json, Business.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Business fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Business)objectMapper.readValue(json, Business.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Business(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.sid = sid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Business other = (Business)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.sid, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("sid", (Object)this.sid).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

