/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.Document;

public class DocumentDeleter
extends Deleter<Document> {
    private final String pathServiceSid;
    private final String pathSid;
    private String ifMatch;

    public DocumentDeleter(String pathServiceSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathSid = pathSid;
    }

    public DocumentDeleter setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, Domains.PREVIEW.toString(), "/Sync/Services/" + this.pathServiceSid + "/Documents/" + this.pathSid + "");
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Document delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return response.getStatusCode() == 204;
    }

    private void addHeaderParams(Request request) {
        if (this.ifMatch != null) {
            request.addHeaderParam("If-Match", this.ifMatch);
        }
    }
}

