/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.deployedDevices.fleet.Deployment;

public class DeploymentUpdater
extends Updater<Deployment> {
    private final String pathFleetSid;
    private final String pathSid;
    private String friendlyName;
    private String syncServiceSid;

    public DeploymentUpdater(String pathFleetSid, String pathSid) {
        this.pathFleetSid = pathFleetSid;
        this.pathSid = pathSid;
    }

    public DeploymentUpdater setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public DeploymentUpdater setSyncServiceSid(String syncServiceSid) {
        this.syncServiceSid = syncServiceSid;
        return this;
    }

    @Override
    public Deployment update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/DeployedDevices/Fleets/" + this.pathFleetSid + "/Deployments/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Deployment update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Deployment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.syncServiceSid != null) {
            request.addPostParam("SyncServiceSid", this.syncServiceSid);
        }
    }
}

