/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.subscription;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.events.v1.subscription.SubscribedEventReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscribedEvent
extends Resource {
    private static final long serialVersionUID = 128787608390551L;
    private final String accountSid;
    private final String type;
    private final Integer version;
    private final String subscriptionSid;
    private final URI url;

    public static SubscribedEventReader reader(String pathSubscriptionSid) {
        return new SubscribedEventReader(pathSubscriptionSid);
    }

    public static SubscribedEvent fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (SubscribedEvent)objectMapper.readValue(json, SubscribedEvent.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static SubscribedEvent fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (SubscribedEvent)objectMapper.readValue(json, SubscribedEvent.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private SubscribedEvent(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="type") String type, @JsonProperty(value="version") Integer version, @JsonProperty(value="subscription_sid") String subscriptionSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.type = type;
        this.version = version;
        this.subscriptionSid = subscriptionSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getType() {
        return this.type;
    }

    public final Integer getVersion() {
        return this.version;
    }

    public final String getSubscriptionSid() {
        return this.subscriptionSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedEvent other = (SubscribedEvent)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.type, other.type) && Objects.equals(this.version, other.version) && Objects.equals(this.subscriptionSid, other.subscriptionSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.type, this.version, this.subscriptionSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("type", (Object)this.type).add("version", (Object)this.version).add("subscriptionSid", (Object)this.subscriptionSid).add("url", (Object)this.url).toString();
    }
}

