/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.events.v1.schema;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.events.v1.schema.Version;

public class VersionReader
extends Reader<Version> {
    private final String pathId;

    public VersionReader(String pathId) {
        this.pathId = pathId;
    }

    @Override
    public ResourceSet<Version> read(TwilioRestClient client) {
        return new ResourceSet<Version>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Version> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.EVENTS.toString(), "/v1/Schemas/" + this.pathId + "/Versions");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Version> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Version> nextPage(Page<Version> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Version> previousPage(Page<Version> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.EVENTS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<Version> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Version read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("schema_versions", response.getContent(), Version.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

