/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.conversations.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.conversations.v1.service.Conversation;
import org.joda.time.DateTime;

public class ConversationCreator
extends Creator<Conversation> {
    private final String pathChatServiceSid;
    private String friendlyName;
    private String uniqueName;
    private String attributes;
    private String messagingServiceSid;
    private DateTime dateCreated;
    private DateTime dateUpdated;
    private Conversation.State state;
    private String timersInactive;
    private String timersClosed;
    private Conversation.WebhookEnabledType xTwilioWebhookEnabled;

    public ConversationCreator(String pathChatServiceSid) {
        this.pathChatServiceSid = pathChatServiceSid;
    }

    public ConversationCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public ConversationCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public ConversationCreator setAttributes(String attributes) {
        this.attributes = attributes;
        return this;
    }

    public ConversationCreator setMessagingServiceSid(String messagingServiceSid) {
        this.messagingServiceSid = messagingServiceSid;
        return this;
    }

    public ConversationCreator setDateCreated(DateTime dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public ConversationCreator setDateUpdated(DateTime dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public ConversationCreator setState(Conversation.State state) {
        this.state = state;
        return this;
    }

    public ConversationCreator setTimersInactive(String timersInactive) {
        this.timersInactive = timersInactive;
        return this;
    }

    public ConversationCreator setTimersClosed(String timersClosed) {
        this.timersClosed = timersClosed;
        return this;
    }

    public ConversationCreator setXTwilioWebhookEnabled(Conversation.WebhookEnabledType xTwilioWebhookEnabled) {
        this.xTwilioWebhookEnabled = xTwilioWebhookEnabled;
        return this;
    }

    @Override
    public Conversation create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.CONVERSATIONS.toString(), "/v1/Services/" + this.pathChatServiceSid + "/Conversations");
        this.addPostParams(request);
        this.addHeaderParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Conversation creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Conversation.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addHeaderParams(Request request) {
        if (this.xTwilioWebhookEnabled != null) {
            request.addHeaderParam("X-Twilio-Webhook-Enabled", this.xTwilioWebhookEnabled.toString());
        }
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.attributes != null) {
            request.addPostParam("Attributes", this.attributes);
        }
        if (this.messagingServiceSid != null) {
            request.addPostParam("MessagingServiceSid", this.messagingServiceSid);
        }
        if (this.dateCreated != null) {
            request.addPostParam("DateCreated", this.dateCreated.toString());
        }
        if (this.dateUpdated != null) {
            request.addPostParam("DateUpdated", this.dateUpdated.toString());
        }
        if (this.state != null) {
            request.addPostParam("State", this.state.toString());
        }
        if (this.timersInactive != null) {
            request.addPostParam("Timers.Inactive", this.timersInactive);
        }
        if (this.timersClosed != null) {
            request.addPostParam("Timers.Closed", this.timersClosed);
        }
    }
}

