/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.conference;

import com.twilio.base.Updater;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.conference.Participant;
import java.net.URI;

public class ParticipantUpdater
extends Updater<Participant> {
    private String pathAccountSid;
    private final String pathConferenceSid;
    private final String pathCallSid;
    private Boolean muted;
    private Boolean hold;
    private URI holdUrl;
    private HttpMethod holdMethod;
    private URI announceUrl;
    private HttpMethod announceMethod;
    private URI waitUrl;
    private HttpMethod waitMethod;
    private Boolean beepOnExit;
    private Boolean endConferenceOnExit;
    private Boolean coaching;
    private String callSidToCoach;

    public ParticipantUpdater(String pathConferenceSid, String pathCallSid) {
        this.pathConferenceSid = pathConferenceSid;
        this.pathCallSid = pathCallSid;
    }

    public ParticipantUpdater(String pathAccountSid, String pathConferenceSid, String pathCallSid) {
        this.pathAccountSid = pathAccountSid;
        this.pathConferenceSid = pathConferenceSid;
        this.pathCallSid = pathCallSid;
    }

    public ParticipantUpdater setMuted(Boolean muted) {
        this.muted = muted;
        return this;
    }

    public ParticipantUpdater setHold(Boolean hold) {
        this.hold = hold;
        return this;
    }

    public ParticipantUpdater setHoldUrl(URI holdUrl) {
        this.holdUrl = holdUrl;
        return this;
    }

    public ParticipantUpdater setHoldUrl(String holdUrl) {
        return this.setHoldUrl(Promoter.uriFromString(holdUrl));
    }

    public ParticipantUpdater setHoldMethod(HttpMethod holdMethod) {
        this.holdMethod = holdMethod;
        return this;
    }

    public ParticipantUpdater setAnnounceUrl(URI announceUrl) {
        this.announceUrl = announceUrl;
        return this;
    }

    public ParticipantUpdater setAnnounceUrl(String announceUrl) {
        return this.setAnnounceUrl(Promoter.uriFromString(announceUrl));
    }

    public ParticipantUpdater setAnnounceMethod(HttpMethod announceMethod) {
        this.announceMethod = announceMethod;
        return this;
    }

    public ParticipantUpdater setWaitUrl(URI waitUrl) {
        this.waitUrl = waitUrl;
        return this;
    }

    public ParticipantUpdater setWaitUrl(String waitUrl) {
        return this.setWaitUrl(Promoter.uriFromString(waitUrl));
    }

    public ParticipantUpdater setWaitMethod(HttpMethod waitMethod) {
        this.waitMethod = waitMethod;
        return this;
    }

    public ParticipantUpdater setBeepOnExit(Boolean beepOnExit) {
        this.beepOnExit = beepOnExit;
        return this;
    }

    public ParticipantUpdater setEndConferenceOnExit(Boolean endConferenceOnExit) {
        this.endConferenceOnExit = endConferenceOnExit;
        return this;
    }

    public ParticipantUpdater setCoaching(Boolean coaching) {
        this.coaching = coaching;
        return this;
    }

    public ParticipantUpdater setCallSidToCoach(String callSidToCoach) {
        this.callSidToCoach = callSidToCoach;
        return this;
    }

    @Override
    public Participant update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Conferences/" + this.pathConferenceSid + "/Participants/" + this.pathCallSid + ".json");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Participant update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Participant.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.muted != null) {
            request.addPostParam("Muted", this.muted.toString());
        }
        if (this.hold != null) {
            request.addPostParam("Hold", this.hold.toString());
        }
        if (this.holdUrl != null) {
            request.addPostParam("HoldUrl", this.holdUrl.toString());
        }
        if (this.holdMethod != null) {
            request.addPostParam("HoldMethod", this.holdMethod.toString());
        }
        if (this.announceUrl != null) {
            request.addPostParam("AnnounceUrl", this.announceUrl.toString());
        }
        if (this.announceMethod != null) {
            request.addPostParam("AnnounceMethod", this.announceMethod.toString());
        }
        if (this.waitUrl != null) {
            request.addPostParam("WaitUrl", this.waitUrl.toString());
        }
        if (this.waitMethod != null) {
            request.addPostParam("WaitMethod", this.waitMethod.toString());
        }
        if (this.beepOnExit != null) {
            request.addPostParam("BeepOnExit", this.beepOnExit.toString());
        }
        if (this.endConferenceOnExit != null) {
            request.addPostParam("EndConferenceOnExit", this.endConferenceOnExit.toString());
        }
        if (this.coaching != null) {
            request.addPostParam("Coaching", this.coaching.toString());
        }
        if (this.callSidToCoach != null) {
            request.addPostParam("CallSidToCoach", this.callSidToCoach);
        }
    }
}

