/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account.call;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.api.v2010.account.call.Payment;
import java.net.URI;

public class PaymentUpdater
extends Updater<Payment> {
    private String pathAccountSid;
    private final String pathCallSid;
    private final String pathSid;
    private final String idempotencyKey;
    private final URI statusCallback;
    private Payment.Capture capture;
    private Payment.Status status;

    public PaymentUpdater(String pathCallSid, String pathSid, String idempotencyKey, URI statusCallback) {
        this.pathCallSid = pathCallSid;
        this.pathSid = pathSid;
        this.idempotencyKey = idempotencyKey;
        this.statusCallback = statusCallback;
    }

    public PaymentUpdater(String pathAccountSid, String pathCallSid, String pathSid, String idempotencyKey, URI statusCallback) {
        this.pathAccountSid = pathAccountSid;
        this.pathCallSid = pathCallSid;
        this.pathSid = pathSid;
        this.idempotencyKey = idempotencyKey;
        this.statusCallback = statusCallback;
    }

    public PaymentUpdater setCapture(Payment.Capture capture) {
        this.capture = capture;
        return this;
    }

    public PaymentUpdater setStatus(Payment.Status status) {
        this.status = status;
        return this;
    }

    @Override
    public Payment update(TwilioRestClient client) {
        this.pathAccountSid = this.pathAccountSid == null ? client.getAccountSid() : this.pathAccountSid;
        Request request = new Request(HttpMethod.POST, Domains.API.toString(), "/2010-04-01/Accounts/" + this.pathAccountSid + "/Calls/" + this.pathCallSid + "/Payments/" + this.pathSid + ".json");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Payment update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Payment.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.idempotencyKey != null) {
            request.addPostParam("IdempotencyKey", this.idempotencyKey);
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.capture != null) {
            request.addPostParam("Capture", this.capture.toString());
        }
        if (this.status != null) {
            request.addPostParam("Status", this.status.toString());
        }
    }
}

