/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1.sim;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.wireless.v1.sim.UsageRecord;
import org.joda.time.DateTime;

public class UsageRecordReader
extends Reader<UsageRecord> {
    private final String pathSimSid;
    private DateTime end;
    private DateTime start;
    private UsageRecord.Granularity granularity;

    public UsageRecordReader(String pathSimSid) {
        this.pathSimSid = pathSimSid;
    }

    public UsageRecordReader setEnd(DateTime end) {
        this.end = end;
        return this;
    }

    public UsageRecordReader setStart(DateTime start) {
        this.start = start;
        return this;
    }

    public UsageRecordReader setGranularity(UsageRecord.Granularity granularity) {
        this.granularity = granularity;
        return this;
    }

    @Override
    public ResourceSet<UsageRecord> read(TwilioRestClient client) {
        return new ResourceSet<UsageRecord>(this, client, this.firstPage(client));
    }

    @Override
    public Page<UsageRecord> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.WIRELESS.toString(), "/v1/Sims/" + this.pathSimSid + "/UsageRecords");
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> nextPage(Page<UsageRecord> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.WIRELESS.toString()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<UsageRecord> previousPage(Page<UsageRecord> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.WIRELESS.toString()));
        return this.pageForRequest(client, request);
    }

    private Page<UsageRecord> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("UsageRecord read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Page.fromJson("usage_records", response.getContent(), UsageRecord.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.end != null) {
            request.addQueryParam("End", this.end.toString());
        }
        if (this.start != null) {
            request.addQueryParam("Start", this.start.toString());
        }
        if (this.granularity != null) {
            request.addQueryParam("Granularity", this.granularity.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

